﻿using System;
using System.Linq;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using Microsoft.WindowsMobile.DirectX;
using Microsoft.WindowsMobile.DirectX.Direct3D;

using Sensors;

namespace Direct3D
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        Device device;

        CustomVertex.PositionColored[] werteksyTrojkata = new CustomVertex.PositionColored[3]
        { 
            new CustomVertex.PositionColored(
                new Vector3(-1, -1, 0),
                Color.Red.ToArgb()),
            new CustomVertex.PositionColored(
                new Vector3(0, 1, 0),
                Color.Yellow.ToArgb()),
            new CustomVertex.PositionColored(
                new Vector3(1, -1, 0),
                Color.Green.ToArgb()) 
        };

        const float dx = 0.5f;
        const float dy = 0.5f;
        const float dz = 0.5f;
        Vector3[] punktyKostki=new Vector3[8]{
            new Vector3(-dx, -dy, dz),
            new Vector3(dx, -dy, dz),
            new Vector3(dx, dy, dz),
            new Vector3(-dx, dy, dz),
            new Vector3(-dx, -dy, -dz),
            new Vector3(dx, -dy, -dz),
            new Vector3(dx, dy, -dz),
            new Vector3(-dx, dy, -dz)};

        Vector3 UnitX=new Vector3(1,0,0);
        Vector3 UnitY=new Vector3(0,1,0);
        Vector3 UnitZ=new Vector3(0,0,1);
                
        //CustomVertex.PositionColored[] werteksyKostki;
        //CustomVertex.PositionTextured[] werteksyKostki;
        CustomVertex.PositionNormalTextured[] werteksyKostki;
        VertexBuffer buforWerteksow;

        Texture tekstura;

        public void Initialize()
        {
            if (device == null)
            {
                //inicjacja urzadzenia
                PresentParameters pp = new PresentParameters();
                pp.Windowed = true;
                pp.SwapEffect = SwapEffect.Discard;
                device = new Device(
                    0,
                    DeviceType.Default,
                    this,
                    CreateFlags.None,
                    pp);


                //device.RenderState.Lighting = false;

                device.RenderState.Lighting = true;


                //swiatla
                const int swOtocz = 50;
                device.Lights[0].Type = LightType.Point;
                device.Lights[0].Ambient = Color.FromArgb(swOtocz, swOtocz, swOtocz);
                device.Lights[0].Diffuse = Color.Red;
                //device.Lights[0].Specular = Color.White;                
                device.Lights[0].Position = new Vector3(2, 0, 1);                
                device.Lights[0].Attenuation0 = 1;
                device.Lights[0].Attenuation1 = 0;
                device.Lights[0].Attenuation2 = 0;
                device.Lights[0].Range = 10;                
                device.Lights[0].Enabled = true;

                device.Lights[1].Type = LightType.Point;
                device.Lights[1].Ambient = Color.FromArgb(swOtocz, swOtocz, swOtocz);
                device.Lights[1].Diffuse = Color.Green;
                //device.Lights[1].Specular = Color.White;
                device.Lights[1].Position = new Vector3(-2, 0, 1);                
                device.Lights[1].Attenuation0 = 1;
                device.Lights[1].Attenuation1 = 0;
                device.Lights[1].Attenuation2 = 0;
                device.Lights[1].Range = 10;                
                device.Lights[1].Enabled = true;

                //materiał
                Material material = new Material();
                material.Ambient = Color.White;
                material.Diffuse = Color.White;
                //material.Specular = Color.White;
                device.Material = material;

                    
                //device.RenderState.CullMode = Cull.None;                

                device.DeviceReset += new EventHandler((object sender, EventArgs e) => { Initialize(); });
            }

            //macierz rzutowania
            float proporcjeObrazu = ((float)device.Viewport.Width) / device.Viewport.Height;
            device.Transform.Projection = Matrix.PerspectiveFovRH(                
                (float)(Math.PI/2),  // kąt widzenia
                proporcjeObrazu,     // proporcje obrazu (aspect ratio)
                1,                   // bliż
                100);                // dal
                
            //macierz widoku
            device.Transform.View = Matrix.LookAtRH(
                new Vector3(0, 0, 2),    // położenie kamery
                new Vector3(0, 0, 0),    // cel, na który jest skierowana
                new Vector3(0, 1, 0));   // polaryzacja (gdzie jest góra kamery)

            //macierz świata
            device.Transform.World = Matrix.Identity;

            //werteksy
            #region Wersja z PositionColored
            /*            
            werteksyKostki = new CustomVertex.PositionColored[24]{
                //przednia sciana
                new CustomVertex.PositionColored(punktyKostki[3], Color.Cyan.ToArgb()),
                new CustomVertex.PositionColored(punktyKostki[2], Color.Cyan.ToArgb()),
                new CustomVertex.PositionColored(punktyKostki[0], Color.Cyan.ToArgb()),
                new CustomVertex.PositionColored(punktyKostki[1], Color.Cyan.ToArgb()),

                //tylnia sciana
                new CustomVertex.PositionColored(punktyKostki[7], Color.Cyan.ToArgb()),
                new CustomVertex.PositionColored(punktyKostki[4], Color.Cyan.ToArgb()),
                new CustomVertex.PositionColored(punktyKostki[6], Color.Cyan.ToArgb()),
                new CustomVertex.PositionColored(punktyKostki[5], Color.Cyan.ToArgb()),
   
                //gorna sciana
                new CustomVertex.PositionColored(punktyKostki[3], Color.Magenta.ToArgb()),
                new CustomVertex.PositionColored(punktyKostki[7], Color.Magenta.ToArgb()),
                new CustomVertex.PositionColored(punktyKostki[2], Color.Magenta.ToArgb()),
                new CustomVertex.PositionColored(punktyKostki[6], Color.Magenta.ToArgb()),

                //dolna sciana
                new CustomVertex.PositionColored(punktyKostki[0], Color.Magenta.ToArgb()),
                new CustomVertex.PositionColored(punktyKostki[1], Color.Magenta.ToArgb()),
                new CustomVertex.PositionColored(punktyKostki[4], Color.Magenta.ToArgb()),
                new CustomVertex.PositionColored(punktyKostki[5], Color.Magenta.ToArgb()),
   
                //lewa sciana
                new CustomVertex.PositionColored(punktyKostki[3], Color.Yellow.ToArgb()),
                new CustomVertex.PositionColored(punktyKostki[0], Color.Yellow.ToArgb()),
                new CustomVertex.PositionColored(punktyKostki[7], Color.Yellow.ToArgb()),
                new CustomVertex.PositionColored(punktyKostki[4], Color.Yellow.ToArgb()),

                //prawa sciana
                new CustomVertex.PositionColored(punktyKostki[1], Color.Yellow.ToArgb()),
                new CustomVertex.PositionColored(punktyKostki[2], Color.Yellow.ToArgb()),
                new CustomVertex.PositionColored(punktyKostki[5], Color.Yellow.ToArgb()),
                new CustomVertex.PositionColored(punktyKostki[6], Color.Yellow.ToArgb())
            };

            buforWerteksow = new VertexBuffer(
                typeof(CustomVertex.PositionColored),
                24,
                device,
                Usage.WriteOnly,
                CustomVertex.PositionColored.Format,
                Pool.SystemMemory);
            buforWerteksow.SetData(werteksyKostki, 0, LockFlags.None);            
            */
            #endregion

            #region Wersja z PositionTextured
            /*
            werteksyKostki = new CustomVertex.PositionTextured[24]{
                //przednia sciana
                new CustomVertex.PositionTextured(punktyKostki[3], 0, 0),
                new CustomVertex.PositionTextured(punktyKostki[2], 1, 0),
                new CustomVertex.PositionTextured(punktyKostki[0], 0, 1),
                new CustomVertex.PositionTextured(punktyKostki[1], 1, 1),

                //tylnia sciana
                new CustomVertex.PositionTextured(punktyKostki[7], 1, 0),
                new CustomVertex.PositionTextured(punktyKostki[4], 1, 1),
                new CustomVertex.PositionTextured(punktyKostki[6], 0, 0),
                new CustomVertex.PositionTextured(punktyKostki[5], 0, 1),
   
                //gorna sciana
                new CustomVertex.PositionTextured(punktyKostki[3], 0, 1),
                new CustomVertex.PositionTextured(punktyKostki[7], 0, 0),
                new CustomVertex.PositionTextured(punktyKostki[2], 1, 1),
                new CustomVertex.PositionTextured(punktyKostki[6], 1, 0),

                //dolna sciana
                new CustomVertex.PositionTextured(punktyKostki[0], 0, 0),
                new CustomVertex.PositionTextured(punktyKostki[1], 1, 0),
                new CustomVertex.PositionTextured(punktyKostki[4], 0, 1),
                new CustomVertex.PositionTextured(punktyKostki[5], 1, 1),
   
                //lewa sciana
                new CustomVertex.PositionTextured(punktyKostki[3], 1, 0),
                new CustomVertex.PositionTextured(punktyKostki[0], 1, 1),
                new CustomVertex.PositionTextured(punktyKostki[7], 0, 0),
                new CustomVertex.PositionTextured(punktyKostki[4], 0, 1),

                //prawa sciana
                new CustomVertex.PositionTextured(punktyKostki[1], 0, 1),
                new CustomVertex.PositionTextured(punktyKostki[2], 0, 0),
                new CustomVertex.PositionTextured(punktyKostki[5], 1, 1),
                new CustomVertex.PositionTextured(punktyKostki[6], 1, 0)
            };

            buforWerteksow = new VertexBuffer(
                typeof(CustomVertex.PositionTextured),
                24,
                device,
                Usage.WriteOnly,
                CustomVertex.PositionTextured.Format,
                Pool.SystemMemory);
            buforWerteksow.SetData(werteksyKostki, 0, LockFlags.None);
            */
            #endregion

            #region Wersja z PositionNormalTextured
            werteksyKostki = new CustomVertex.PositionNormalTextured[24]{
                //przednia sciana
                new CustomVertex.PositionNormalTextured(punktyKostki[3], UnitZ, 0, 0),
                new CustomVertex.PositionNormalTextured(punktyKostki[2], UnitZ, 1, 0),
                new CustomVertex.PositionNormalTextured(punktyKostki[0], UnitZ, 0, 1),
                new CustomVertex.PositionNormalTextured(punktyKostki[1], UnitZ, 1, 1),

                //tylnia sciana
                new CustomVertex.PositionNormalTextured(punktyKostki[7], -UnitZ, 1, 0),
                new CustomVertex.PositionNormalTextured(punktyKostki[4], -UnitZ, 1, 1),
                new CustomVertex.PositionNormalTextured(punktyKostki[6], -UnitZ, 0, 0),
                new CustomVertex.PositionNormalTextured(punktyKostki[5], -UnitZ, 0, 1),
   
                //gorna sciana
                new CustomVertex.PositionNormalTextured(punktyKostki[3], UnitY, 0, 1),
                new CustomVertex.PositionNormalTextured(punktyKostki[7], UnitY, 0, 0),
                new CustomVertex.PositionNormalTextured(punktyKostki[2], UnitY, 1, 1),
                new CustomVertex.PositionNormalTextured(punktyKostki[6], UnitY, 1, 0),

                //dolna sciana
                new CustomVertex.PositionNormalTextured(punktyKostki[0], -UnitY, 0, 0),
                new CustomVertex.PositionNormalTextured(punktyKostki[1], -UnitY, 1, 0),
                new CustomVertex.PositionNormalTextured(punktyKostki[4], -UnitY, 0, 1),
                new CustomVertex.PositionNormalTextured(punktyKostki[5], -UnitY, 1, 1),
   
                //lewa sciana
                new CustomVertex.PositionNormalTextured(punktyKostki[3], -UnitX, 1, 0),
                new CustomVertex.PositionNormalTextured(punktyKostki[0], -UnitX, 1, 1),
                new CustomVertex.PositionNormalTextured(punktyKostki[7], -UnitX, 0, 0),
                new CustomVertex.PositionNormalTextured(punktyKostki[4], -UnitX, 0, 1),

                //prawa sciana
                new CustomVertex.PositionNormalTextured(punktyKostki[1], UnitX, 0, 1),
                new CustomVertex.PositionNormalTextured(punktyKostki[2], UnitX, 0, 0),
                new CustomVertex.PositionNormalTextured(punktyKostki[5], UnitX, 1, 1),
                new CustomVertex.PositionNormalTextured(punktyKostki[6], UnitX, 1, 0)
            };

            buforWerteksow = new VertexBuffer(
                typeof(CustomVertex.PositionNormalTextured),
                24,
                device,
                Usage.WriteOnly,
                CustomVertex.PositionNormalTextured.Format,
                Pool.SystemMemory);
            buforWerteksow.SetData(werteksyKostki, 0, LockFlags.None);
            #endregion

            //teksturowanie
            device.RenderState.TexturePerspective = true;
            tekstura = TextureLoader.FromStream(device, new System.IO.FileStream(@"\Temp\Tekstura.bmp", System.IO.FileMode.Open));
            device.SetTexture(0, tekstura);
        }
      
        private void Draw()
        {
            ustawMacierzSwiata();            

            device.Clear(ClearFlags.Target, Color.Black, 1.0f, 0);
            device.BeginScene();

            //w tym miejscu umieścimy polecenia rysowania obiektów 3D
            device.SetStreamSource(0, buforWerteksow, 0);
            //device.DrawPrimitives(PrimitiveType.TriangleList, 0, 1);
            for (int i = 0; i < 6; ++i)
                device.DrawPrimitives(PrimitiveType.TriangleStrip, 4 * i, 2);

            device.EndScene();
            device.Present();
        }

        protected override void OnPaint(PaintEventArgs e)
        {
            Draw();
        }

        protected override void OnPaintBackground(PaintEventArgs e)
        {
        }

        #region Transformacje
        bool trwaPrzeciaganie = false;
        const float odsuniecie = 0.5f; //we wsp. ekranu
        private Vector3 poprzedniePolozenie = new Vector3(0, 0, 0);

        Matrix macierzTranslacji = Matrix.Identity;
        Matrix macierzObrotow = Matrix.Identity;

        Vector3 polozeniePrezentacja = new Vector3(0, 0, 0);

        private void Form1_MouseDown(object sender, MouseEventArgs e)
        {
            if (trwaPrzeciaganie) return;
            trwaPrzeciaganie = true; 

            poprzedniePolozenie = new Vector3(e.X, e.Y, odsuniecie);
            poprzedniePolozenie.Unproject(
                device.Viewport,
                device.Transform.Projection,
                device.Transform.View,
                macierzTranslacji);
        }

        private void Form1_MouseUp(object sender, MouseEventArgs e)
        {
            trwaPrzeciaganie = false; 
        }

        private void Form1_MouseMove(object sender, MouseEventArgs e)
        {
            if (!trwaPrzeciaganie) return;

            Vector3 polozenie = new Vector3(e.X, e.Y, odsuniecie);
            polozenie.Unproject(
                device.Viewport,
                device.Transform.Projection,
                device.Transform.View,
                macierzTranslacji);
            Vector3 przesuniecie = polozenie - poprzedniePolozenie;
            przesuniecie.Z = 0;                        

            macierzTranslacji *= Matrix.Translation(przesuniecie);

            polozeniePrezentacja += przesuniecie; //tylko do wyswietlania

            Invalidate();            
        }

        private void ustawMacierzSwiata()
        {
            device.Transform.World = Matrix.Identity;
            device.Transform.World *= macierzObrotow;
            device.Transform.World *= macierzTranslacji;
        }

        void wyswietlWektor(Vector3 wektor)
        {
            Vector3 p = wektor;
            string x = p.X.ToString(); if (x.Length > 5) x = x.Substring(0, 4);
            string y = p.Y.ToString(); if (y.Length > 5) y = y.Substring(0, 4);
            string z = p.Z.ToString(); if (z.Length > 5) z = z.Substring(0, 4);
            this.Text = x + " " + y + " " + z;            
        }

        /*
        private void timer1_Tick(object sender, EventArgs e)
        {            
            macierzObrotow *= Matrix.RotationY(0.1f);

            Invalidate();
        }
        */
        #endregion

        #region Akcelerometr
        IGSensor gs=GSensorFactory.CreateGSensor();
        Vector3 poprzedniePrzyspieszenie;
        bool czyAkcelerometrDostepny = true;
        bool poczatek = true;

        private void timer1_Tick(object sender, EventArgs e)
        {
            if (false) //tu mozna odblokowac odczyt akceleratora
            {
                if (!czyAkcelerometrDostepny) return;

                try
                {
                    GVector gv = gs.GetGVector();
                    wyswietlWektor(gv.ToVector3());
                    if (poczatek)
                    {
                        poprzedniePrzyspieszenie = gv.ToVector3();
                        poczatek = false;
                    }
                    Vector3 przyspieszenie = gv.ToVector3();
                    Vector3 osObrotu = Vector3.Cross(poprzedniePrzyspieszenie, przyspieszenie);
                    osObrotu.Normalize();
                    float cosKataObrotu = Vector3.Dot(poprzedniePrzyspieszenie, przyspieszenie) / (przyspieszenie.Length() * poprzedniePrzyspieszenie.Length());
                    if (cosKataObrotu > 1) cosKataObrotu = 1;
                    float katObrotu = (float)Math.Acos(cosKataObrotu);
                    poprzedniePrzyspieszenie = przyspieszenie;

                    macierzObrotow *= Matrix.RotationAxis(osObrotu, katObrotu);
                }
                catch (Exception exc)
                {
                    czyAkcelerometrDostepny = false;
                    MessageBox.Show("Błąd obsługi akceleratora: " + exc.Message);
                }
            }
            else
            {
                macierzObrotow *= Matrix.RotationY(0.1f);
                //macierzObrotow = Matrix.RotationY(0.7f);
            }

            Invalidate();
        }
        #endregion
    }

    static class Rozszerzenia
    {
        public static Vector3 ToVector3(this GVector g)
        {
            return new Vector3((float)g.X, -(float)g.Y, (float)g.Z);
        }
    }
}